# Q3 Horizon‑Proximity (NoCommit) — Reproducible Simulation

This repo reproduces the **Stage Q3** simulation: interference visibility collapse as one interferometer arm approaches an *operational horizon* implemented by a structural **ParentGate** (NoCommit inside, boolean gating outside).

## Quick start
1. **Python 3.9+** with **NumPy**.
2. Run:
   ```bash
   python3 q3_horizon.py
   ```
3. Artifacts are written to `out/q3/`:
   - `q3_horizon_visibility_summary.csv`
   - `q3_horizon_scans.csv`
   - `q3_horizon_manifest.yaml`
   - `q3_horizon_audit.json`

## Model highlights
- Acceptance is **boolean/ordinal** only; no continuous curve weights.
- **PF/Born** is used **only** when both output ports are simultaneously constructive (`|C|=2`).
- **NoCommit** at/inside the horizon blocks the lower arm completely.
- Jitter half‑width `J=0.15` (in units of period `Θ=1`), window `ε=0.10` (non‑overlapping).

## Parameters
- Distances: `d ∈ {20,12,8,4,2,1,0,-2}`.
- Seeds: `{101,202,303}` (aggregated).
- Trials: `K=20,000` per δt scan point; `201` δt points in `[-0.5, +0.5]`.

## Files
- **`q3_horizon.py`** — single‑file simulator.
- **`out/q3/*.csv|yaml|json`** — results, manifest, and audit.

